<?php
/**
 * Final Setup & Installation Script
 * Updated: 2025-10-15 19:17:50 UTC
 * Created by: saportinsta65
 */

// Security check
if (!isset($_GET['setup']) || $_GET['setup'] !== 'captaintrade2025') {
    http_response_code(404);
    exit('Not Found');
}

?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نصب ربات کاپیتان ترید</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Segoe UI', Tahoma, Arial, sans-serif; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; padding: 20px; }
        .container { max-width: 800px; margin: 0 auto; background: white; border-radius: 20px; box-shadow: 0 20px 40px rgba(0,0,0,0.1); overflow: hidden; }
        .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px; text-align: center; }
        .header h1 { font-size: 2.5em; margin-bottom: 10px; }
        .header p { font-size: 1.2em; opacity: 0.9; }
        .content { padding: 40px; }
        .step { margin-bottom: 30px; padding: 25px; border: 2px solid #e1e5e9; border-radius: 15px; background: #f8f9fa; }
        .step.completed { border-color: #28a745; background: #d4edda; }
        .step.error { border-color: #dc3545; background: #f8d7da; }
        .step h3 { color: #333; margin-bottom: 15px; display: flex; align-items: center; }
        .step-icon { font-size: 1.5em; margin-left: 10px; }
        .check-item { margin: 10px 0; padding: 10px; border-radius: 8px; background: white; display: flex; justify-content: space-between; align-items: center; }
        .status-ok { color: #28a745; font-weight: bold; }
        .status-error { color: #dc3545; font-weight: bold; }
        .btn { display: inline-block; padding: 12px 25px; border-radius: 8px; text-decoration: none; font-weight: bold; margin: 5px; }
        .btn-primary { background: #007bff; color: white; }
        .btn-success { background: #28a745; color: white; }
        .btn-warning { background: #ffc107; color: black; }
        .footer { background: #f8f9fa; padding: 20px; text-align: center; color: #666; }
        code { background: #f1f3f4; padding: 2px 6px; border-radius: 4px; font-family: monospace; }
        .progress { width: 100%; height: 20px; background: #e9ecef; border-radius: 10px; overflow: hidden; margin: 20px 0; }
        .progress-bar { height: 100%; background: linear-gradient(90deg, #28a745, #20c997); transition: width 0.5s; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🚀 نصب ربات کاپیتان ترید</h1>
            <p>سیستم حرفه‌ای آموزش فارکس</p>
            <div class="progress">
                <div class="progress-bar" style="width: <?= getInstallProgress() ?>%"></div>
            </div>
        </div>
        
        <div class="content">
            <?php
            // Check installation status
            $checks = runSystemChecks();
            $progress = getInstallProgress();
            
            if ($progress < 100): ?>
                <div class="step">
                    <h3><span class="step-icon">🔧</span> بررسی سیستم</h3>
                    <?php foreach ($checks as $check => $result): ?>
                        <div class="check-item">
                            <span><?= $result['name'] ?></span>
                            <span class="<?= $result['status'] ? 'status-ok' : 'status-error' ?>">
                                <?= $result['status'] ? '✅ OK' : '❌ Error' ?>
                            </span>
                        </div>
                    <?php endforeach; ?>
                </div>
                
                <?php if (allChecksPassed($checks)): ?>
                    <div class="step completed">
                        <h3><span class="step-icon">⚙️</span> پیکربندی</h3>
                        <p>✅ همه بررسی‌ها موفق بود!</p>
                        <a href="?setup=captaintrade2025&action=install" class="btn btn-success">شروع نصب</a>
                    </div>
                <?php endif; ?>
                
            <?php else: ?>
                <div class="step completed">
                    <h3><span class="step-icon">🎉</span> نصب کامل شد!</h3>
                    <p>ربات کاپیتان ترید با موفقیت نصب و پیکربندی شد.</p>
                    
                    <div style="margin-top: 20px;">
                        <h4>🔗 لینک‌های مهم:</h4>
                        <ul style="list-style: none; padding: 0;">
                            <li>🤖 <strong>ربات:</strong> <code>@almascapitanbot</code></li>
                            <li>👨‍💼 <strong>پنل ادمین:</strong> <a href="admin/" target="_blank">admin/</a></li>
                            <li>🧪 <strong>تست سیستم:</strong> <a href="test.php" target="_blank">test.php</a></li>
                            <li>📊 <strong>وضعیت:</strong> <a href="health.php" target="_blank">health.php</a></li>
                        </ul>
                    </div>
                    
                    <div style="margin-top: 20px;">
                        <h4>🎯 مراحل بعدی:</h4>
                        <ol>
                            <li>ربات را در تلگرام تست کنید</li>
                            <li>پنل ادمین را بررسی کنید</li>
                            <li>تنظیمات را به‌روزرسانی کنید</li>
                            <li>این فایل را حذف کنید</li>
                        </ol>
                    </div>
                    
                    <a href="/" class="btn btn-primary">ورود به سایت</a>
                    <a href="admin/" class="btn btn-success">پنل ادمین</a>
                </div>
            <?php endif; ?>
            
            <?php if (isset($_GET['action']) && $_GET['action'] === 'install'): ?>
                <div class="step">
                    <h3><span class="step-icon">⚡</span> در حال نصب...</h3>
                    <?php performInstallation(); ?>
                </div>
            <?php endif; ?>
        </div>
        
        <div class="footer">
            <p>🔥 ساخته شده با عشق توسط saportinsta65</p>
            <p>💎 کاپیتان ترید - سیستم حرفه‌ای آموزش فارکس</p>
        </div>
    </div>
</body>
</html>

<?php
function runSystemChecks() {
    $checks = [
        'php_version' => [
            'name' => 'نسخه PHP (نیاز: 7.4+)',
            'status' => version_compare(PHP_VERSION, '7.4.0', '>=')
        ],
        'curl' => [
            'name' => 'افزونه cURL',
            'status' => extension_loaded('curl')
        ],
        'pdo' => [
            'name' => 'افزونه PDO',
            'status' => extension_loaded('pdo')
        ],
        'json' => [
            'name' => 'افزونه JSON',
            'status' => extension_loaded('json')
        ],
        'openssl' => [
            'name' => 'افزونه OpenSSL',
            'status' => extension_loaded('openssl')
        ],
        'config' => [
            'name' => 'فایل config.php',
            'status' => file_exists('config.php')
        ],
        'includes' => [
            'name' => 'پوشه includes',
            'status' => is_dir('includes')
        ],
        'writable' => [
            'name' => 'دسترسی نوشتن logs',
            'status' => is_writable('logs') || mkdir('logs', 0755, true)
        ],
        'database' => [
            'name' => 'اتصال دیتابیس',
            'status' => testDatabaseConnection()
        ]
    ];
    
    return $checks;
}

function testDatabaseConnection() {
    if (!file_exists('config.php')) return false;
    
    try {
        require_once 'config.php';
        $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
        return true;
    } catch (Exception $e) {
        return false;
    }
}

function allChecksPassed($checks) {
    foreach ($checks as $check) {
        if (!$check['status']) return false;
    }
    return true;
}

function getInstallProgress() {
    $checks = runSystemChecks();
    $total = count($checks);
    $passed = 0;
    
    foreach ($checks as $check) {
        if ($check['status']) $passed++;
    }
    
    return ($passed / $total) * 100;
}

function performInstallation() {
    echo "<div class='check-item'><span>🔧 ایجاد جداول دیتابیس...</span>";
    try {
        require_once 'config.php';
        require_once 'includes/database.php';
        $db = new Database();
        echo "<span class='status-ok'>✅ موفق</span></div>";
    } catch (Exception $e) {
        echo "<span class='status-error'>❌ خطا: " . $e->getMessage() . "</span></div>";
        return;
    }
    
    echo "<div class='check-item'><span>🔗 تنظیم Webhook...</span>";
    try {
        $webhook_url = 'https://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) . '/index.php';
        $api_url = "https://api.telegram.org/bot" . BOT_TOKEN . "/setWebhook?url=" . urlencode($webhook_url);
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
        
        $result = json_decode($response, true);
        if ($result && $result['ok']) {
            echo "<span class='status-ok'>✅ موفق</span></div>";
        } else {
            echo "<span class='status-error'>❌ خطا</span></div>";
        }
    } catch (Exception $e) {
        echo "<span class='status-error'>❌ خطا: " . $e->getMessage() . "</span></div>";
    }
    
    echo "<div class='check-item'><span>📁 ایجاد پوشه‌ها...</span>";
    $folders = ['logs', 'uploads', 'backup'];
    foreach ($folders as $folder) {
        if (!is_dir($folder)) {
            mkdir($folder, 0755, true);
        }
    }
    echo "<span class='status-ok'>✅ موفق</span></div>";
    
    echo "<div class='check-item'><span>🎯 تست ربات...</span>";
    try {
        require_once 'includes/telegram.php';
        $telegram = new TelegramBot(BOT_TOKEN);
        $test = $telegram->testConnection();
        
        if ($test['success']) {
            echo "<span class='status-ok'>✅ موفق</span></div>";
        } else {
            echo "<span class='status-error'>❌ خطا</span></div>";
        }
    } catch (Exception $e) {
        echo "<span class='status-error'>❌ خطا: " . $e->getMessage() . "</span></div>";
    }
    
    echo "<script>setTimeout(() => window.location.reload(), 2000);</script>";
}
?>